% LaTeX class for the Journal of Digital Terminology and Lexicography (JDTL)
% Based on Springer Nature's LaTeX class (sn-jnl.cls)
% ----------------------------------------------------------
% This document is an extension of the Springer Nature LaTeX template
% for submissions to the Journal of Digital Terminology and Lexicography.
% ----------------------------------------------------------
% Template: jdtl_template.text (based on sn-jnl.cls)
% Version: 2.3
% Authors: [Giorgio Maria Di Nunzio]
% Date: [2025/11/12]
% Journal: Journal of Digital Terminology and Lexicography (JDTL)
% APA Reference Style
% ----------------------------------------------------------

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{jdtl}[2025/11/12 Custom wrapper for sn-jnl Springer Nature]

% Pass all options to sn-jnl.cls
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{sn-jnl}}
\ProcessOptions\relax

% Load the base class
\LoadClass{sn-jnl}

% Now you can add customizations here

%%%% DO NOT CHANGE THESE VALUES %%%%
%%%% %%%%%%%%%%%%%%%%% %%%%
%
%
% Set custom margins for A4 paper
\setlength{\textheight}{23.1cm} 		% Adjust the text height for bottom margin
\setlength{\textwidth}{15.1cm} 		% Adjust the text width for left and right margins
\setlength{\oddsidemargin}{0.3cm} 	% Left margin (adjust to control)
\setlength{\evensidemargin}{0.5cm}	% Right margin (adjust to control)
\setlength{\topmargin}{0.5cm} 		% Top margin
\setlength{\headheight}{0cm}     	% Space for headers (if needed)
\setlength{\headsep}{1.0cm}        	% Space between header and text
\setlength{\footskip}{35pt}    		% Space from bottom of text to footer (larger = lower footer)

\RequirePackage{libertinus} 	% Libertinus font package
\RequirePackage[T1]{fontenc}
\RequirePackage{graphicx} 	% Example: To include graphics
\RequirePackage{listings}   	% Example: To include sourc ecode
\RequirePackage{amsmath} 	% Example: For mathematical symbols
\RequirePackage{booktabs}
\RequirePackage{lipsum} 		% To generate Lorem Ipsum text, remove it when necessart
\RequirePackage{fancyhdr}

%##############%##############%##############%##############


% Custom first page style
\fancypagestyle{first}{

  \fancyhf{}  % clear

% Header: custom info
\fancyhead[L]{
\small
Journal of Digital Terminology and Lexicography - ISSN:3103-3601 \\ 
 Vol.~\JDTLVOL{}, No.~\JDTLNUM{} (\JDTLYEAR{})%
%Author Name(s), Short Title}
}
%\fancyhead[C]{}

\fancyhead[R]{
\small
DOI: \JDTLDOI
}


% Footer: page numbers
\fancyfoot[L]{
\small
Copyright \copyright \JDTLCOPYRIGHTYEAR~The Author(s) \\
\includegraphics[height=1.5\normalbaselineskip]{ccby.png}
}

\fancyfoot[C]{\thepage}
%\fancyfoot[CE]{\thepage}

}

% ---------- EVEN PAGES ----------
\fancyhead[LE]{
\small
JDTL - Vol.~\JDTLVOL{}, No.~\JDTLNUM{} (\JDTLYEAR)%
}
\fancyhead[RE]{
\small
DOI: \JDTLDOI
}
%\fancyfoot[CE]{\thepage}
%\fancyfoot[CE]{0}

% ---------- ODD PAGES ----------
\fancyhead[LO]{
\small
%Bonato - \emph{Biomedical Annotation for Gut-Brain Interplay}
\JDTLRUNNINGTITLE{}
}
\fancyfoot[CO]{\thepage}
%\fancyfoot[CE]{0}


\renewcommand{\subsectionmark}[1]

\endinput
